#include <objbase.h>
#include <Dbt.h>
#include <windows.h>

static GUID GUID_DEVINTERFACE_USB_DEVICE =
{0xA5DCBF10, 0x6530, 0x11D2, {0x90, 0x1F, 0x00, 0xC0,
                              0x4F, 0xB9, 0x51, 0xED}};

//---------------------------------------------------------
bool hidDeviceNotify(HWND hwnd, GUID GUID_DEVINTERFACE_HID,
                     HDEVNOTIFY *hidDeviceNotify)
{
    DEV_BROADCAST_DEVICEINTERFACE NotificationFilter;
    ZeroMemory(&NotificationFilter, sizeof(NotificationFilter));
    NotificationFilter.dbcc_size = sizeof(DEV_BROADCAST_DEVICEINTERFACE);
    NotificationFilter.dbcc_devicetype = DBT_DEVTYP_DEVICEINTERFACE;
    NotificationFilter.dbcc_classguid = GUID_DEVINTERFACE_USB_DEVICE;
    *hidDeviceNotify = RegisterDeviceNotification(hwnd, &NotificationFilter,
                                               DEVICE_NOTIFY_WINDOW_HANDLE);
    if(!hidDeviceNotify)
    return false;

    return true;
}
//---------------------------------------------------------
LRESULT CALLBACK WindowProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    switch(uMsg) {
      case WM_DEVICECHANGE:
         MessageBox(NULL, "Jedno z urzdze USB zostao odczone/przyczone!",
                    "Uwaga!", MB_ICONEXCLAMATION | MB_OK);
    break;
      default:
         return DefWindowProc(hwnd, uMsg, wParam, lParam);
    }
    return 0;
}
//---------------------------------------------------------
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE, LPSTR, int)
{
    HWND hWnd;
    WNDCLASSEX wndClassEx;
    HDEVNOTIFY hDeviceNotify;
    MSG Msg;
    wndClassEx.cbSize        = sizeof(WNDCLASSEX);
    wndClassEx.style         = 0;
    wndClassEx.lpfnWndProc   = WindowProc;
    wndClassEx.cbClsExtra    = 0;
    wndClassEx.cbWndExtra    = 0;
    wndClassEx.hInstance     = hInstance;
    wndClassEx.lpszClassName = "DeviceNotifyTest";

    if(!RegisterClassEx(&wndClassEx)){
      MessageBox(NULL, "Bd rejestracji okna!", "Bd!",
                 MB_ICONEXCLAMATION | MB_OK);
      return 0;
    }

    hWnd = CreateWindowEx(WS_EX_CLIENTEDGE,"DeviceNotifyTest"," ",WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT, 0, 0, NULL, NULL,
                          hInstance, NULL);
    if(hWnd == NULL){
      MessageBox(NULL, "Bd utworzenia okna!", "Bd!",
                 MB_ICONEXCLAMATION | MB_OK);
      return 0;
    }

    if(!hidDeviceNotify(NULL, GUID_DEVINTERFACE_USB_DEVICE, &hDeviceNotify)){
       MessageBox(NULL, "Bd wykonania funkcji hidDeviceNotify().",
                 "Bd!", MB_ICONEXCLAMATION | MB_OK);
      return 1;
    }
    MessageBox(NULL, "Funkcja hidDeviceNotify() wykonana pomylnie.",
               "Uwaga!", MB_ICONEXCLAMATION | MB_OK);

    while(GetMessage(&Msg, NULL, 0, 0) > 0){
      TranslateMessage(&Msg);
              DispatchMessage(&Msg);
    }
    return Msg.wParam;
}
//---------------------------------------------------------
 
